from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class Grudger(Player):
    """
    A player starts by cooperating however will defect if at any point the
    opponent has defected.

    This strategy came 7th in Axelrod's original tournament.

    Names:

    - Friedman's strategy: [Axelrod1980]_
    - Grudger: [Li2011]_
    - Grim: [Berg2015]_
    - Grim Trigger: [Banks1990]_
    - Spite: [Beaufils1997]_
    - Spiteful: [Mathieu2015]_
    - Vengeful: [Ashlock2009]_
    """

    name = "Grudger"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Begins by playing C, then plays D for the remaining rounds if the
        opponent ever plays D."""
        if opponent.defections:
            return D
        return C